   IPLR                          2            #include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct stretch_effect_fragment_main_out
{
    float4 frag_color [[color(0)]];
};

struct stretch_effect_fragment_main_in
{
    float2 _fragCoord [[user(locn0)]];
};

fragment stretch_effect_fragment_main_out stretch_effect_fragment_main(stretch_effect_fragment_main_in in [[stage_in]], constant float2& u_size [[buffer(0)]], constant float& u_overscroll_x [[buffer(2)]], constant float& u_overscroll_y [[buffer(3)]], constant float& u_interpolation_strength [[buffer(4)]], texture2d<float> u_texture [[texture(0)]], sampler u_textureSmplr [[sampler(0)]])
{
    stretch_effect_fragment_main_out out = {};
    float2 _189 = in._fragCoord / u_size;
    float _194 = _189.x;
    float _198 = _189.y;
    bool _204 = u_overscroll_y != 0.0;
    float _210 = _204 ? u_overscroll_y : u_overscroll_x;
    float _215 = 1.0 / (1.0 + abs(_210));
    float _218 = _215 - 1.0;
    float _560;
    if (_204)
    {
        _560 = _194;
    }
    else
    {
        float _559;
        do
        {
            if (_210 > 0.0)
            {
                if (_194 <= 1.0)
                {
                    float _369 = 1.0 - _194;
                    _559 = _215 - (_369 / (1.0 + (_210 * mix(1.0, _369, u_interpolation_strength))));
                    break;
                }
                else
                {
                    _559 = _218 + _194;
                    break;
                }
                break; // unreachable workaround
            }
            else
            {
                if (_210 < 0.0)
                {
                    if (_194 >= 0.0)
                    {
                        _559 = 1.0 - (_215 - (_194 / (1.0 + ((-_210) * mix(1.0, _194, u_interpolation_strength)))));
                        break;
                    }
                    else
                    {
                        _559 = (1.0 - _215) + _194;
                        break;
                    }
                    break; // unreachable workaround
                }
                else
                {
                    _559 = _194;
                    break;
                }
                break; // unreachable workaround
            }
            break; // unreachable workaround
        } while(false);
        _560 = _559;
    }
    float _562;
    if (_204)
    {
        float _561;
        do
        {
            if (_210 > 0.0)
            {
                if (_198 <= 1.0)
                {
                    float _501 = 1.0 - _198;
                    _561 = _215 - (_501 / (1.0 + (_210 * mix(1.0, _501, u_interpolation_strength))));
                    break;
                }
                else
                {
                    _561 = _218 + _198;
                    break;
                }
                break; // unreachable workaround
            }
            else
            {
                if (_210 < 0.0)
                {
                    if (_198 >= 0.0)
                    {
                        _561 = 1.0 - (_215 - (_198 / (1.0 + ((-_210) * mix(1.0, _198, u_interpolation_strength)))));
                        break;
                    }
                    else
                    {
                        _561 = (1.0 - _215) + _198;
                        break;
                    }
                    break; // unreachable workaround
                }
                else
                {
                    _561 = _198;
                    break;
                }
                break; // unreachable workaround
            }
            break; // unreachable workaround
        } while(false);
        _562 = _561;
    }
    else
    {
        _562 = _198;
    }
    out.frag_color = u_texture.sample(u_textureSmplr, float2(_560, _562));
    return out;
}

      h           P      $                                   u_interpolation_strength    (                                       u_overscroll_y  (                                       u_overscroll_x  $                                   u_max_stretch_intensity :                            	   u_texture  $                                               u_size     stretch_effect_fragment_main                         // This SkSL shader is autogenerated by spirv-cross.

float4 flutter_FragCoord;

uniform vec2 u_size;
uniform float u_max_stretch_intensity;
uniform float u_overscroll_x;
uniform float u_overscroll_y;
uniform float u_interpolation_strength;
uniform shader u_texture;
uniform half2 u_texture_size;

vec4 frag_color;

vec2 FLT_flutter_local_FlutterFragCoord()
{
    return flutter_FragCoord.xy;
}

float FLT_flutter_local_ease_in(float t, float d)
{
    return t * d;
}

float FLT_flutter_local_compute_overscroll_start(float in_pos, float overscroll, float u_stretch_affected_dist, float u_inverse_stretch_affected_dist, float distance_stretched, float interpolation_strength)
{
    float offset_pos = u_stretch_affected_dist - in_pos;
    float param = offset_pos;
    float param_1 = u_inverse_stretch_affected_dist;
    float pos_based_variation = mix(1.0, FLT_flutter_local_ease_in(param, param_1), interpolation_strength);
    float stretch_intensity = overscroll * pos_based_variation;
    return distance_stretched - (offset_pos / (1.0 + stretch_intensity));
}

float FLT_flutter_local_compute_overscroll_end(float in_pos, float overscroll, float reverse_stretch_dist, float u_stretch_affected_dist, float u_inverse_stretch_affected_dist, float distance_stretched, float interpolation_strength, float viewport_dimension)
{
    float offset_pos = in_pos - reverse_stretch_dist;
    float param = offset_pos;
    float param_1 = u_inverse_stretch_affected_dist;
    float pos_based_variation = mix(1.0, FLT_flutter_local_ease_in(param, param_1), interpolation_strength);
    float stretch_intensity = (-overscroll) * pos_based_variation;
    return viewport_dimension - (distance_stretched - (offset_pos / (1.0 + stretch_intensity)));
}

float FLT_flutter_local_compute_streched_effect(float in_pos, float overscroll, float u_stretch_affected_dist, float u_inverse_stretch_affected_dist, float distance_stretched, float distance_diff, float interpolation_strength, float viewport_dimension)
{
    if (overscroll > 0.0)
    {
        if (in_pos <= u_stretch_affected_dist)
        {
            float param = in_pos;
            float param_1 = overscroll;
            float param_2 = u_stretch_affected_dist;
            float param_3 = u_inverse_stretch_affected_dist;
            float param_4 = distance_stretched;
            float param_5 = interpolation_strength;
            return FLT_flutter_local_compute_overscroll_start(param, param_1, param_2, param_3, param_4, param_5);
        }
        else
        {
            return distance_diff + in_pos;
        }
    }
    else
    {
        if (overscroll < 0.0)
        {
            float stretch_affected_dist_calc = viewport_dimension - u_stretch_affected_dist;
            if (in_pos >= stretch_affected_dist_calc)
            {
                float param_6 = in_pos;
                float param_7 = overscroll;
                float param_8 = stretch_affected_dist_calc;
                float param_9 = u_stretch_affected_dist;
                float param_10 = u_inverse_stretch_affected_dist;
                float param_11 = distance_stretched;
                float param_12 = interpolation_strength;
                float param_13 = viewport_dimension;
                return FLT_flutter_local_compute_overscroll_end(param_6, param_7, param_8, param_9, param_10, param_11, param_12, param_13);
            }
            else
            {
                return (-distance_diff) + in_pos;
            }
        }
        else
        {
            return in_pos;
        }
    }
}

void FLT_main()
{
    vec2 uv = FLT_flutter_local_FlutterFragCoord() / u_size;
    float in_u_norm = uv.x;
    float in_v_norm = uv.y;
    bool isVertical = u_overscroll_y != 0.0;
    float overscroll_1 = isVertical ? u_overscroll_y : u_overscroll_x;
    float norm_distance_stretched = 1.0 / (1.0 + abs(overscroll_1));
    float norm_dist_diff = norm_distance_stretched - 1.0;
    float _223;
    if (isVertical)
    {
        _223 = in_u_norm;
    }
    else
    {
        float param_14 = in_u_norm;
        float param_15 = overscroll_1;
        float param_16 = 1.0;
        float param_17 = 1.0;
        float param_18 = norm_distance_stretched;
        float param_19 = norm_dist_diff;
        float param_20 = u_interpolation_strength;
        float param_21 = 1.0;
        _223 = FLT_flutter_local_compute_streched_effect(param_14, param_15, param_16, param_17, param_18, param_19, param_20, param_21);
    }
    float out_u_norm = _223;
    float _246;
    if (isVertical)
    {
        float param_22 = in_v_norm;
        float param_23 = overscroll_1;
        float param_24 = 1.0;
        float param_25 = 1.0;
        float param_26 = norm_distance_stretched;
        float param_27 = norm_dist_diff;
        float param_28 = u_interpolation_strength;
        float param_29 = 1.0;
        _246 = FLT_flutter_local_compute_streched_effect(param_22, param_23, param_24, param_25, param_26, param_27, param_28, param_29);
    }
    else
    {
        _246 = in_v_norm;
    }
    float out_v_norm = _246;
    uv.x = out_u_norm;
    uv.y = out_v_norm;
    frag_color = u_texture.eval(u_texture_size * ( uv));
}

half4 main(float2 iFragCoord)
{
      flutter_FragCoord = float4(iFragCoord, 0, 0);
      FLT_main();
      return frag_color;
}
      X        P      z$                                   u_interpolation_strength    $                                   u_overscroll_y     (              $                                   u_overscroll_x     ,              (                                       u_max_stretch_intensity    $                                         	   u_texture                                             u_size     stretch_effect_fragment_main    